/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.integrator;

import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class VWParameterTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 4;
    protected static final int COL_NAME = 0;
    protected static final int COL_TYPE = 1;
    protected static final int COL_MODE = 2;
    protected static final int COL_DESCRIPTION = 3;
    private static final String s_array = "[ ]";
    private VWOperationDefinition m_operationDefinition = null;
    private Frame m_parentFrame = null;
    private Vector m_rowData = null;
    private boolean m_bIsModified = false;

    public VWParameterTableModel(Frame parentFrame) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_rowData = new Vector();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean isModified() {
        return this.m_bIsModified;
    }

    public void refresh(VWOperationDefinition operationDef) {
        try {
            VWParameterDefinition[] parameterDefs;
            this.m_operationDefinition = operationDef;
            this.m_rowData.removeAllElements();
            if (this.m_operationDefinition != null && (parameterDefs = this.m_operationDefinition.getParameterDefinitions()) != null && parameterDefs.length > 0) {
                for (int i = 0; i < parameterDefs.length; ++i) {
                    this.m_rowData.addElement(parameterDefs[i]);
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        this.m_parentFrame = null;
        this.m_operationDefinition = null;
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.Name;
            }
            case 1: {
                return VWResource.Type;
            }
            case 2: {
                return VWResource.Access;
            }
            case 3: {
                return VWResource.Description;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_operationDefinition != null && this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWParameterDefinition parameterDef = this.getRowItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (parameterDef != null) {
                        return parameterDef.getName();
                    }
                    return "";
                }
                case 1: {
                    return this.getParameterTypeString(parameterDef);
                }
                case 2: {
                    if (parameterDef != null) {
                        return VWModeType.getLocalizedString(parameterDef.getMode());
                    }
                    return "";
                }
                case 3: {
                    if (parameterDef != null) {
                        return parameterDef.getDescription();
                    }
                    return "";
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                this.onUpdateName(aValue, nRowIndex);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.onUpdateDescription(aValue, nRowIndex);
            }
        }
    }

    private VWParameterDefinition getRowItemAt(int nRowIndex) {
        VWParameterDefinition parameterDef = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            parameterDef = (VWParameterDefinition)this.m_rowData.elementAt(nRowIndex);
        }
        return parameterDef;
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        try {
            if (aValue == null || !(aValue instanceof String)) {
                return;
            }
            String newName = ((String)aValue).trim();
            if (newName.length() == 0) {
                return;
            }
            VWParameterDefinition parameterDef = this.getRowItemAt(nRowIndex);
            if (parameterDef != null) {
                if (VWStringUtils.compare(newName, parameterDef.getName()) == 0) {
                    return;
                }
                parameterDef.setName(newName);
                this.m_bIsModified = true;
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
        }
    }

    private void onUpdateDescription(Object aValue, int nRowIndex) {
        try {
            if (aValue == null) {
                return;
            }
            VWParameterDefinition parameterDef = this.getRowItemAt(nRowIndex);
            if (parameterDef != null) {
                parameterDef.setDescription(aValue.toString());
                this.m_bIsModified = true;
            }
            this.fireTableCellUpdated(nRowIndex, 3);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getParameterTypeString(VWParameterDefinition parameterDef) {
        String type = null;
        try {
            if (parameterDef == null) return type;
            switch (parameterDef.getDataType()) {
                case 64: {
                    return VWResource.s_workflowGroup;
                }
                default: {
                    type = VWFieldType.getLocalizedString(parameterDef.getDataType());
                    if (!parameterDef.getIsArray()) return type;
                    return type + s_array;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return type;
    }
}

